import { action } from '@storybook/addon-actions';
import { Meta } from '@storybook/react';
import { modalService, useDismounted } from '@yandex-infracloud-ui/libs';
import { Button } from 'lego-on-react';
import React, { useCallback } from 'react';
import { takeUntil } from 'rxjs/operators';

import { ReleaseRule, ReleaseRuleType, ReleaseType } from '../../../../../../models/ui';
import { apiServicesContextDecorator, modalsSupportDecorator } from '../../../../../../stories';

import { RuleRemoveModal } from './RuleRemoveModal';

const rule: ReleaseRule = {
   autocommit: true,
   creationDate: Date.now(),
   description: '',
   form: {
      autocommit: true,
      description: 'description',
      docker: {
         patches: [
            {
               id: 'patch1',
               deployUnitId: 'DeployUnit1',
               boxId: 'Box1',
            },
         ],
         image: '',
      },
      id: 'test-release-rule',
      releaseTypes: [ReleaseType.Testing],
      sandbox: undefined,
      type: ReleaseRuleType.Docker,
   },
   id: 'test-release-rule',
   patchCount: 1,
   stageId: 'test-stage',
   type: ReleaseRuleType.Docker,
};

export const Form = () => <RuleRemoveModal rule={rule} ok={action('ok')} cancel={action('cancel')} />;

export const Modal = () => {
   const dismounted = useDismounted();

   const open = useCallback(() => {
      modalService
         .open(RuleRemoveModal, { rule }, { closeOnOutsideClick: false })
         .pipe(takeUntil(dismounted))
         .subscribe(action('success'), action('error or dismiss'));
   }, [dismounted]);

   return (
      <Button theme={'action'} size={'s'} onClick={open}>
         Open modal
      </Button>
   );
};

export default {
   decorators: [modalsSupportDecorator, apiServicesContextDecorator],
   title: 'pages/stages/_stageId/deploy-tickets/RuleRemoveModal',
} as Meta;
