import React, { ReactNode, useMemo } from 'react';
import { DeployTicketsBlock } from '../../../../../../components/deployTicket';
import { DeployTicketFilters } from '../../../../../../models/ui';
import { SelectDeployTicketOptions } from '../../../../../../redux';
import { DeployTicketsEmptyContainer } from '../DeployTicketsEmptyContainer/DeployTicketsEmptyContainer';

import { GetDeployTicketsReqOptions } from '../../../../../../services/api/services/YpApi';
import { Column, DeployTicketPageType } from '../../../../../../components/deployTicket/model';

const excludeColumns: Set<Column> = new Set(['stage']);
interface Props {
   stageId: string;
   headerPanel?: ReactNode;
}

export const StageDeployTickets: React.FC<Props> = React.memo(({ stageId, headerPanel }) => {
   const selectOptions: SelectDeployTicketOptions = useMemo(() => ({ stageId }), [stageId]);
   const requestOptions: GetDeployTicketsReqOptions = useMemo(() => ({ stageId }), [stageId]);
   const defaultFilters: Partial<DeployTicketFilters> = useMemo(() => ({ stageId }), [stageId]);
   return (
      <DeployTicketsBlock
         pageType={DeployTicketPageType.stage}
         headerPanel={headerPanel}
         selectOptions={selectOptions}
         requestOptions={requestOptions}
         defaultFilters={defaultFilters}
         excludeColumns={excludeColumns}
         emptyBlock={<DeployTicketsEmptyContainer stageId={stageId} />}
      />
   );
});

StageDeployTickets.displayName = 'StageDeployTickets';
