import { DeclarativeFields, FieldLayout2 } from '@yandex-infracloud-ui/libs';
import React from 'react';
import classes from './ApprovalPolicyForm.module.scss';
import { ExclusionsSubForm } from './components/ExclusionsSubForm/ExclusionsSubForm';

import { fields } from './models';

export const ApprovalPolicyForm: React.FC<{ stageId: string }> = React.memo(({ stageId }) => (
   <div className={classes.form} data-e2e={'ApprovalPolicy:Form'}>
      <div className={classes.declarative}>
         <DeclarativeFields configs={fields} />
      </div>
      <div className={classes.exclusions}>
         <FieldLayout2 name={'exclusions'} label={'Exclusions: Release rules'} hideErrors={true}>
            <ExclusionsSubForm name={'exclusions'} readonly={false} disabled={false} stageId={stageId} />
         </FieldLayout2>
      </div>
   </div>
));

ApprovalPolicyForm.displayName = 'ApprovalPolicyForm';
