import React, { ReactNode } from 'react';

import { ReleaseRuleExclusionsField } from '../../fields/ReleaseRuleExclusionsField/ReleaseRuleExclusionsField';

import classes from './ExclusionsSubForm.module.scss';

interface Props {
   disabled: boolean;
   hint?: ReactNode;
   name: string;
   readonly: boolean;
   stageId: string;
}

export const ExclusionsSubForm: React.FC<Props> = React.memo(({ readonly, disabled, name, hint, stageId }) => (
   <div className={classes.form}>
      <ReleaseRuleExclusionsField name={`${name}.releaseRules`} stageId={stageId} />
   </div>
));

ExclusionsSubForm.displayName = 'ExclusionsSubForm';
