import { EnumField2, ExtendedFieldConfig, InputField2, SwitcherField2 } from '@yandex-infracloud-ui/libs';
import React from 'react';
import {
   ApprovalModeType,
   ApprovalPolicyFormParams,
   ApprovalPolicyType,
} from '../../../../../../../../models/ui/approvalPolicy';
import TooltipInfo from '../../../../../../../../old-code/components/TooltipInfo/TooltipInfo';

export const fields: Array<ExtendedFieldConfig<ApprovalPolicyFormParams>> = [
   {
      as: SwitcherField2,
      name: 'activeMode',
      label: (
         <span>
            Use approval policy <TooltipInfo note={'approvalsMode'} directions={['bottom-center']} />
         </span>
      ),
      controlProps: {
         options: [
            { value: ApprovalModeType.Optional, title: 'Optional' },
            { value: ApprovalModeType.Required, title: 'Required' },
         ],
      },
   },
   {
      as: InputField2,
      name: 'count',
      label: (
         <span>
            Regular approves <TooltipInfo note={'approvalsCount'} directions={['bottom-center']} />
         </span>
      ),
   },
   {
      as: EnumField2,
      name: 'mandatoryPolicy',
      label: (
         <span>
            Mandatory approves <TooltipInfo note={'approvalsPolicy'} directions={['bottom-center']} />
         </span>
      ),
      controlProps: {
         options: [
            { value: ApprovalPolicyType.Mandatory, title: 'On' },
            { value: ApprovalPolicyType.Default, title: 'Off' },
         ],
      },
   },
];
