import { Meta } from '@storybook/react';
import React from 'react';

import { apiServicesContextDecorator, configContextDecorator, RouteRenderer } from '../../../../stories';

import { StageDeployTicketListPage } from './index';

export const Regular = () => (
   <RouteRenderer
      component={StageDeployTicketListPage}
      path={'/stages/:stageId/deploy-tickets'}
      url={'/stages/test-release-integration-stage/deploy-tickets'}
   />
);

export const Empty = () => (
   <RouteRenderer
      component={StageDeployTicketListPage}
      path={'/stages/:stageId/deploy-tickets'}
      url={'/stages/khoden_e2e/deploy-tickets'}
   />
);

export default {
   decorators: [configContextDecorator, apiServicesContextDecorator],
   title: 'pages/stages/_stageId/deploy-tickets/StageDeployTicketListPage',
} as Meta;
