import { useTitle } from '@yandex-infracloud-ui/libs';
import React from 'react';
import { RouteComponentProps } from 'react-router';

import classes from './index.module.scss';
import { ApprovalPolicyTooltip } from './components/ApprovalPolicyTooltip/ApprovalPolicyTooltip';
import { StageDeployTickets } from './components/StageDeployTickets/StageDeployTickets';

interface RouteParams {
   stageId: string;
   ticketId?: string;
}

export const StageDeployTicketListPage: React.FC<RouteComponentProps<RouteParams>> = React.memo(({ match }) => {
   const { stageId } = match.params;

   useTitle(`Deploy tickets / Stage ${stageId}`);

   const approval = <ApprovalPolicyTooltip stageId={stageId} />;

   return (
      <div className={classes.page} data-e2e={'Tickets:Body'}>
         <StageDeployTickets stageId={stageId} headerPanel={approval} />
      </div>
   );
   // endregion
});

StageDeployTicketListPage.displayName = 'StageDeployTicketListPage';
