import React, { useCallback } from 'react';

import { faSpinner, faUndo } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Button } from '@yandex-cloud/uikit';
import { useTitle } from '@yandex-infracloud-ui/libs';
import { RouteComponentProps } from 'react-router';

import { EditSharedNode } from '../../../../components/lib';
import { StageHugeForm } from '../../../../components/stage-huge-form';
import { StageHugeFormMode, StageHugeFormShowPage } from '../../../../components/stage-huge-form/models';
import { urlBuilder } from '../../../../models';
import { useFormStage } from '../../../../redux';
import { RenderArgs } from '../../../../components/stage-huge-form/StageHugeForm';

const renderChildren = (form: RenderArgs) => (
   <>
      <EditSharedNode replace={true}>
         {form.contentEditViewSwitcher}

         {form.showPage === StageHugeFormShowPage.Edit && form.hasUnsavedChanges ? (
            <Button onClick={form.revert} extraProps={{ 'data-e2e': 'StageHugeForm:RevertUnsavedChangesButton' }}>
               <FontAwesomeIcon icon={faUndo} />
               &nbsp;&nbsp; Revert changes
            </Button>
         ) : null}

         <Button onClick={form.cancel} extraProps={{ 'data-e2e': 'StageHugeForm:CancelButton' }}>
            {form.showPage === StageHugeFormShowPage.Diff
               ? 'Edit'
               : form.showPage === StageHugeFormShowPage.Update
               ? 'Back'
               : 'Cancel'}
         </Button>

         <Button
            view={'action'}
            onClick={form.update}
            extraProps={{ 'data-e2e': 'StageHugeForm:UpdateButton' }}
            disabled={form.showPage === StageHugeFormShowPage.Diff || form.isSubmitting || form.isDisabledActions}
         >
            {form.isSubmitting ? (
               <>
                  <FontAwesomeIcon icon={faSpinner} spin={true} /> Checking
               </>
            ) : (
               'Review Changes'
            )}
         </Button>
      </EditSharedNode>

      {form.content}
   </>
);

export const StageEditPage: React.FC<RouteComponentProps<{ stageId: string }>> = React.memo(
   ({ location, match, history }) => {
      const { stageId } = match.params;

      const { rawStage } = useFormStage(StageHugeFormMode.Edit, stageId);

      useTitle(`Edit / ${stageId}`);

      const handleCancel = useCallback(() => {
         history.push(urlBuilder.stageConfig(stageId));
      }, [history, stageId]);

      if (!rawStage) {
         return null;
      }

      return (
         <StageHugeForm mode={StageHugeFormMode.Edit} onCancel={handleCancel} rawStage={rawStage}>
            {renderChildren}
         </StageHugeForm>
      );
   },
);

StageEditPage.displayName = 'StageEditPage';
