import React from 'react';

import { RouteComponentProps } from 'react-router';

import { getHistoryEventStageRevision } from '../../../../../../models/ui';
import { useStage } from '../../../../../../redux';
import { StageHistorySpecSingle, StageHistoryBackButton, StageHistoryEventPlaceholder } from '../../components';
import { useCheckRevisions, useHistoryEvent, useHistoryList } from '../../hooks';

export const StageHistoryEventDetailsPage: React.FC<
   RouteComponentProps<{ stageId: string; revisionId: string }>
> = React.memo(({ match }) => {
   const { stageId, revisionId: stringRevisionId } = match.params;
   const revisionId = Number(stringRevisionId);

   const { historyEvent } = useHistoryEvent(stageId, revisionId);
   const { summary } = useCheckRevisions(stageId, [revisionId]);
   const { historyList } = useHistoryList(stageId);
   const { stage } = useStage(stageId);

   return (
      <div style={{ padding: '0 var(--horizontalOffset)', paddingTop: 'var(--normalOffset)' }}>
         <StageHistoryBackButton stageId={stageId} />

         {summary.type === 'ok' && historyEvent ? (
            <StageHistorySpecSingle
               stageId={stageId}
               revisionId={revisionId}
               currentRevision={stage?.revision ?? 0}
               historyEvent={historyEvent}
               availableRevisions={historyList.map(getHistoryEventStageRevision)}
            />
         ) : (
            <StageHistoryEventPlaceholder
               stageId={stageId}
               revisionIds={Array.from(summary.revisions)}
               state={summary.type}
            />
         )}
      </div>
   );
});

StageHistoryEventDetailsPage.displayName = 'StageHistoryEventDetailsPage';
