import React from 'react';

import { RouteComponentProps } from 'react-router';

import { getHistoryEventStageRevision } from '../../../../../../models/ui';
import { StageHistorySpecCompared, StageHistoryBackButton, StageHistoryEventPlaceholder } from '../../components';
import { useCheckRevisions, useHistoryEvent, useHistoryList } from '../../hooks';

export const StageHistoryEventDiffPage: React.FC<
   RouteComponentProps<{ stageId: string; revisionId: string; revisionComparedId: string }>
> = React.memo(({ match }) => {
   const { stageId, revisionId: stringRevisionId, revisionComparedId: stringRevisionComparedId } = match.params;
   const revisionId = Number(stringRevisionId);
   const revisionComparedId = Number(stringRevisionComparedId);

   const { historyEvent } = useHistoryEvent(stageId, revisionId);
   const { summary } = useCheckRevisions(stageId, [revisionId, revisionComparedId]);
   const { historyList } = useHistoryList(stageId);

   return (
      <div style={{ padding: 'var(--normalOffset) var(--horizontalOffset)' }}>
         <StageHistoryBackButton stageId={stageId} />
         {summary.type === 'ok' && historyEvent ? (
            <StageHistorySpecCompared
               stageId={stageId}
               revisionId={revisionId}
               revisionIdCompared={revisionComparedId}
               availableRevisions={historyList.map(getHistoryEventStageRevision)}
            />
         ) : (
            <StageHistoryEventPlaceholder
               stageId={stageId}
               revisionIds={Array.from(summary.revisions)}
               state={summary.type}
            />
         )}
      </div>
   );
});

StageHistoryEventDiffPage.displayName = 'StageHistoryEventDiffPage';
