import React from 'react';

import { RouteComponentProps } from 'react-router';

import { StageHistoryEventPlaceholder, StageRollbackInternalForm } from '../../components';
import { useCheckRevisions, useHistoryEvent } from '../../hooks';

export const StageHistoryEventEditPage: React.FC<
   RouteComponentProps<{ stageId: string; revisionId: string }>
> = React.memo(({ match, location }) => {
   const asIs = location.pathname.endsWith('applyAsIs');
   const { stageId, revisionId: strRevisionId } = match.params;
   const revisionId = Number(strRevisionId);

   const { historyEvent } = useHistoryEvent(stageId, revisionId);
   const { summary } = useCheckRevisions(stageId, [revisionId]);

   return (
      <>
         {summary.type === 'ok' && historyEvent ? (
            <StageRollbackInternalForm
               asIs={asIs}
               historyEvent={historyEvent}
               stageId={stageId}
               revisionId={revisionId}
            />
         ) : (
            <StageHistoryEventPlaceholder
               stageId={stageId}
               revisionIds={Array.from(summary.revisions)}
               state={summary.type}
            />
         )}
      </>
   );
});

StageHistoryEventEditPage.displayName = 'StageHistoryEventEditPage';
