import React from 'react';
import { faArrowLeft } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Link } from 'react-router-dom';

import { urlBuilder } from '../../../../../../models';

interface Props {
   stageId: string;
}

export const StageHistoryBackButton: React.FC<Props> = React.memo(({ stageId }) => (
   <div>
      <Link to={urlBuilder.stageHistory(stageId)} data-test={'StageHistory:BackHistoryButton'}>
         <FontAwesomeIcon icon={faArrowLeft} size={'lg'} fixedWidth={true} pull={'left'} />
         Back to History
      </Link>
   </div>
));

StageHistoryBackButton.displayName = 'StageHistoryBackButton';
