import React from 'react';
import { useParams } from 'react-router-dom';

import classes from './StageHistoryErrorHeader.module.css';

interface RouteParams {
   stageId?: string;
   revisionId?: string;
   revisionIdCompared?: string;
}

export const StageHistoryErrorHeader: React.FC = React.memo(() => {
   const { revisionId, revisionIdCompared } = useParams<RouteParams>();

   return (
      <h3 className={classes.title}>
         {revisionIdCompared
            ? `History diff between revision ${revisionId} and revision ${revisionIdCompared}`
            : `History for revision ${revisionId}`}
      </h3>
   );
});

StageHistoryErrorHeader.displayName = 'StageHistoryErrorHeader';
