import React from 'react';

import { faUndo } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Button, Popover } from '@yandex-cloud/uikit';
import { classNames } from '@yandex-infracloud-ui/libs';
import { Link } from 'react-router-dom';

import { getHistoryEventStageRevision, HistoryEvent } from '../../../../../../models/ui';
import { urlBuilder } from '../../../../../../models';
import { handleStopPropagation } from '../../../../../../utils';

import classes from './StageHistoryEventActions.module.css';

interface Props {
   historyEvent: HistoryEvent;
   stageId: string;
}

export const StageHistoryEventActions: React.FC<Props> = React.memo(({ historyEvent, stageId }) => {
   const revisionId = getHistoryEventStageRevision(historyEvent);
   return (
      <div
         className={classNames(classes.applySpec)}
         onClick={handleStopPropagation}
         role={'button'}
         aria-label={'Apply'}
         tabIndex={0}
      >
         <Popover
            content={
               <>
                  Changes from revision {revisionId}
                  <div className={classes.applyPopup} data-test={'StageHistory:ApplyPopup'}>
                     <Link
                        className={classes.applyButton}
                        to={{ pathname: urlBuilder.stageHistoryApply(stageId, revisionId, true) }}
                        data-test={'StageHistory:ApplyAsIsLink'}
                     >
                        <div className={classes.applyButtonTitle}>Apply as is</div>
                        <div className={classes.applyButtonComment}>Skip spec update</div>
                     </Link>
                     <Link
                        className={classes.applyButton}
                        to={{ pathname: urlBuilder.stageHistoryApply(stageId, revisionId, false) }}
                        data-test={'StageHistory:ApplyWithChangesLink'}
                     >
                        <div className={classes.applyButtonTitle}>Apply with changes</div>
                        <div className={classes.applyButtonComment}>Update spec</div>
                     </Link>
                  </div>
               </>
            }
            placement={['bottom-end', 'top-end']}
            hasArrow={false}
            openOnHover={false}
            autoclosable={true}
         >
            <Button view={'action'}>
               <FontAwesomeIcon icon={faUndo} /> Apply
            </Button>
         </Popover>
      </div>
   );
});
StageHistoryEventActions.displayName = 'StageHistoryEventActions';
