import React from 'react';

import { formatDate } from '@yandex-infracloud-ui/libs';

import { getHistoryEventTimestamp, HistoryEvent } from '../../../../../../models/ui';

interface Props {
   historyEvent: HistoryEvent;
}

export const StageHistoryEventDate: React.FC<Props> = React.memo(({ historyEvent }) => {
   const date = new Date(getHistoryEventTimestamp(historyEvent));

   return <>{formatDate(date, 'MMM, d, yyyy, HH:mm:ss')}</>;
});

StageHistoryEventDate.displayName = 'StageHistoryEventDate';
