import React from 'react';

import { EmptyContainer, EmptyContainerType } from '@yandex-infracloud-ui/libs';
import { Spin } from '@yandex-cloud/uikit';

import { RevisionsState } from '../../hooks';
import { StageHistorySpecError } from '../StageHistorySpecError/StageHistorySpecError';

import classes from './StageHistoryEventPlaceholder.module.css';

interface Props {
   stageId: string;
   revisionIds: number[];
   state: RevisionsState;
}

export const StageHistoryEventPlaceholder: React.FC<Props> = React.memo(({ stageId, revisionIds, state }) => {
   const prefix = `Revision${revisionIds.length > 1 ? 's' : ''} ${revisionIds.join(', ')}`;
   if (state === 'not_found') {
      return <EmptyContainer type={EmptyContainerType.NotFound} description={`${prefix} not found`} />;
   }

   if (state === 'error') {
      return (
         <div className={classes.container}>
            {revisionIds.map(id => (
               <div key={id}>
                  Error for revision {id}
                  <StageHistorySpecError stageId={stageId} revisionId={id} />
               </div>
            ))}
         </div>
      );
   }

   if (state === 'loading') {
      return (
         <div className={classes.container}>
            <Spin size={'xl'} />
            <div>loading {prefix}</div>
         </div>
      );
   }

   return null;
});

StageHistoryEventPlaceholder.displayName = 'StageHistoryEventPlaceholder';
