import React from 'react';

import { MiniBox } from '../../../../../../components/lib';
import { StageHistoryEventRevision } from '../StageHistoryEventRevision/StageHistoryEventRevision';
import { StageHistoryEventDate } from '../StageHistoryEventDate/StageHistoryEventDate';
import { StageHistoryUserLink } from '../StageHistoryUserLink/StageHistoryUserLink';
import { StageHistoryEventActions } from '../StageHistoryEventActions/StageHistoryEventActions';
import { StageHistoryMessage } from '../StageHistoryMessage/StageHistoryMessage';
import { useHistoryGoto } from '../../hooks';
import { getHistoryEventStageRevision, HistoryEvent } from '../../../../../../models/ui';

import classes from './StageHistoryList.module.css';

interface Props {
   stageId: string;
   currentRevision: number;
   historyEvent: HistoryEvent;
}

export const StageHistoryListRow: React.FC<Props> = React.memo(({ stageId, currentRevision, historyEvent }) => {
   const revision = getHistoryEventStageRevision(historyEvent);
   const isCurrentRevision = currentRevision === revision;

   const { gotoHistoryEvent } = useHistoryGoto(stageId);

   return (
      <>
         <tr
            data-test={'StageHistory:Revision'}
            className={classes.historyTableRow}
            onClick={() => gotoHistoryEvent(revision)}
         >
            <td data-test={'StageHistory:RevisionId'}>
               <StageHistoryEventRevision historyEvent={historyEvent} />
            </td>
            <td data-test={'StageHistory:RevisionTime'}>
               <StageHistoryEventDate historyEvent={historyEvent} />
            </td>
            <td data-test={'StageHistory:RevisionUser'}>
               <StageHistoryUserLink historyEvent={historyEvent} />
            </td>
            <td data-test={'StageHistory:RevisionMessage'} className={classes.messageCol}>
               <MiniBox
                  fullTextTitle={`Description ${revision ? `for Revision ${revision}` : ''}`}
                  height={'100px'}
                  preferenceMode={'block'}
                  showMoreTitle={'view full message'}
                  width={'100%'}
               >
                  <StageHistoryMessage historyEvent={historyEvent} />
               </MiniBox>
            </td>
            <td data-test={'StageHistory:RevisionActions'}>
               {isCurrentRevision && (
                  <div className={classes.currentRevision} data-test={'StageHistory:CurrentRevision'}>
                     Current revision
                  </div>
               )}
               {!isCurrentRevision && (
                  <div className={classes.historyActions}>
                     <StageHistoryEventActions historyEvent={historyEvent} stageId={stageId} />
                  </div>
               )}
            </td>
         </tr>
      </>
   );
});

StageHistoryListRow.displayName = 'StageHistoryListRow';
