import React, { useContext } from 'react';
import { EMPTY_VALUE, ExternalLink } from '@yandex-infracloud-ui/libs';

import { StartrekRenderMode, StartrekTicket } from '../../../../../../components';
import { HistoryEvent } from '../../../../../../models/ui';
import { handleStopPropagation } from '../../../../../../utils';
import { TextParserType } from '../../../../../../utils/parsers/parseTextToObjects';
import { HistoryDescriptionsContext } from '../../context';

interface Props {
   historyEvent: HistoryEvent;
}

export const StageHistoryMessage: React.FC<Props> = React.memo(({ historyEvent }) => {
   const revisionId = historyEvent?.result?.spec?.revision ?? null;
   const description = historyEvent?.result?.spec?.revision_info?.description ?? null;

   const historyDescriptions = useContext(HistoryDescriptionsContext);

   if (!revisionId || !description) {
      return <>{EMPTY_VALUE}</>;
   }

   const customDescription = historyDescriptions.get(revisionId);

   if (!customDescription) {
      return <>{description ?? EMPTY_VALUE}</>;
   }

   return (
      <>
         {customDescription.map(({ text, type }) => {
            if (type === TextParserType.STARTREK_TICKET) {
               return <StartrekTicket id={text} lazyLoad={true} mode={StartrekRenderMode.HOVER_TOOLTIP} />;
            }

            if (type === TextParserType.LINK) {
               return (
                  <ExternalLink href={text} onClick={handleStopPropagation}>
                     {text}
                  </ExternalLink>
               );
            }

            return <>{text}</>;
         })}
      </>
   );
});

StageHistoryMessage.displayName = 'StageHistoryMessage';
