import React from 'react';

import { HistoryEvent } from '../../../../../../models/ui';
import { TStageSpec } from '../../../../../../proto-typings';
import { StageHistoryMessage } from '../StageHistoryMessage/StageHistoryMessage';
import { MiniBox } from '../../../../../../components/lib';

interface Props {
   historyEvent: HistoryEvent;
}

export const StageHistoryMessageBlock: React.FC<Props> = React.memo(({ historyEvent }) => {
   const historySpec: TStageSpec | undefined = historyEvent.result.spec;
   return (
      <div data-test={'StageHistory:MessageBlock'}>
         {historySpec?.revision_info?.description ? (
            <MiniBox
               fullTextTitle={`Description ${historySpec?.revision ? `for Revision ${historySpec?.revision}` : ''}`}
               preferenceMode={'text'}
               showMoreTitle={'view full message'}
               width={'700px'}
            >
               <StageHistoryMessage historyEvent={historyEvent} />
            </MiniBox>
         ) : (
            <span data-test={'StageHistory:MessageEmpty'}>No message</span>
         )}
      </div>
   );
});

StageHistoryMessageBlock.displayName = 'StageHistoryMessageBlock';
