import React from 'react';

import { faArrowsH, faInfoCircle } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Button, Popover } from '@yandex-cloud/uikit';
import { YCSelect } from '@yandex-data-ui/common';

import { DiffView } from '../../../../../../components/lib';
import { useHistoryEventText, useHistoryGoto } from '../../hooks';
import { HistoryRevisionSummary } from './components/HistoryRevisionSummary/HistoryRevisionSummary';
import { getRevisionItem } from '../../model';

import classes from './StageHistorySpecCompared.module.css';

interface Props {
   stageId: string;
   revisionId: number;
   revisionIdCompared: number;
   availableRevisions: number[];
}

export const StageHistorySpecCompared: React.FC<Props> = React.memo(
   ({ revisionId, revisionIdCompared, availableRevisions, stageId }) => {
      const { gotoHistoryCompare } = useHistoryGoto(stageId);
      const { historyEventText: specText } = useHistoryEventText(stageId, revisionId);
      const { historyEventText: specTextDiff } = useHistoryEventText(stageId, revisionIdCompared);
      return (
         <div className={classes.diffViewerCompared} data-test={'StageHistory:DiffViewer'}>
            <DiffView
               language={'yaml'}
               modified={specTextDiff || ''}
               original={specText}
               leftToolbar={
                  <div className={classes.diffSpec} data-test={'StageHistory:RevisionDiffSpec'}>
                     <div className={classes.revisionSelectControl} data-test={'StageHistory:DiffRevision'}>
                        <div data-test={'StageHistory:SelectRevision'}>
                           <YCSelect
                              className={classes.revisionSelect}
                              value={String(revisionId)}
                              items={availableRevisions.filter(e => e !== revisionIdCompared).map(getRevisionItem)}
                              onUpdate={(value: string) => gotoHistoryCompare(Number(value), revisionIdCompared, true)}
                           />
                        </div>
                        <Popover
                           className={classes.revisionTooltip}
                           tooltipClassName={classes.revisionSummary}
                           content={<HistoryRevisionSummary stageId={stageId} revisionId={revisionId} />}
                           placement={['bottom']}
                           hasArrow={false}
                           title={`Revision ${revisionId}`}
                           hasClose={true}
                           openOnHover={false}
                        >
                           <div className={'revision-1'} data-test={'StageHistory:RevisionSummaryButton'}>
                              <Button view={'outlined'} pin={'clear-round'}>
                                 <FontAwesomeIcon icon={faInfoCircle} />
                              </Button>
                           </div>
                        </Popover>
                     </div>
                     <div data-test={'StageHistory:RearrangeRevisions'}>
                        <button
                           className={classes.buttonRearrange}
                           onClick={e => {
                              e.stopPropagation();
                              gotoHistoryCompare(revisionIdCompared, revisionId);
                           }}
                           type={'button'}
                        >
                           <FontAwesomeIcon icon={faArrowsH} />
                        </button>
                     </div>
                     <div className={classes.revisionSelectControl} data-test={'StageHistory:DiffComparedRevision'}>
                        <div data-test={'StageHistory:SelectRevision'}>
                           <YCSelect
                              className={classes.revisionSelect}
                              value={String(revisionIdCompared)}
                              items={availableRevisions.filter(e => e !== revisionId).map(getRevisionItem)}
                              onUpdate={(value: string) => gotoHistoryCompare(revisionId, Number(value), true)}
                           />
                        </div>
                        <Popover
                           className={classes.revisionTooltip}
                           tooltipClassName={classes.revisionSummary}
                           content={<HistoryRevisionSummary stageId={stageId} revisionId={revisionIdCompared} />}
                           placement={['bottom']}
                           hasArrow={false}
                           title={`Revision ${revisionIdCompared}`}
                           hasClose={true}
                           openOnHover={false}
                        >
                           <div className={'revision-2'} data-test={'StageHistory:RevisionSummaryButton'}>
                              <Button view={'outlined'} pin={'clear-round'}>
                                 <FontAwesomeIcon icon={faInfoCircle} />
                              </Button>
                           </div>
                        </Popover>
                     </div>
                  </div>
               }
               unified={false}
            />
         </div>
      );
   },
);

StageHistorySpecCompared.displayName = 'StageHistorySpecCompared';
