import React from 'react';
import { faCode } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Button } from '@yandex-cloud/uikit';

import { useHistoryEvent, useHistoryGoto } from '../../../../hooks';
import { StageHistoryEventDate } from '../../../StageHistoryEventDate/StageHistoryEventDate';
import { StageHistoryUserLink } from '../../../StageHistoryUserLink/StageHistoryUserLink';
import { StageHistoryMessageBlock } from '../../../StageHistoryMessageBlock/StageHistoryMessageBlock';

import classes from './HistoryRevisionSummary.module.css';

interface Props {
   stageId: string;
   revisionId: number;
}

export const HistoryRevisionSummary: React.FC<Props> = React.memo(({ revisionId, stageId }) => {
   const { gotoHistoryEvent } = useHistoryGoto(stageId);
   const { historyEvent } = useHistoryEvent(stageId, revisionId);

   if (!historyEvent) {
      return null;
   }

   return (
      <div className={classes.summary} data-test={'StageHistory:RevisionSummary'}>
         <div className={classes.info}>
            Created on <StageHistoryEventDate historyEvent={historyEvent} /> by{' '}
            <StageHistoryUserLink historyEvent={historyEvent} />
         </div>
         <StageHistoryMessageBlock historyEvent={historyEvent} />
         <div className={classes.showYaml} data-test={'StageHistory:ShowYaml'}>
            <Button
               view={'normal'}
               onClick={e => {
                  e.stopPropagation();
                  gotoHistoryEvent(revisionId);
               }}
            >
               <FontAwesomeIcon icon={faCode} /> Show yaml
            </Button>
         </div>
      </div>
   );
});

HistoryRevisionSummary.displayName = 'HistoryRevisionSummary';
