import React from 'react';
import { YpErrorTooltip } from '../../../../../../components/network';
import { HistorySpecRequestKeys } from '../../../../../../models/ui/history';
import { useNetworkErrors } from '../../../../../../redux';

interface Props {
   stageId: string;
   revisionId: number;
}

export const StageHistorySpecError: React.FC<Props> = React.memo(({ stageId, revisionId }) => {
   const requestKey = HistorySpecRequestKeys.getOne({ id: stageId, revisionId: String(revisionId) });
   const networkErrors = useNetworkErrors([requestKey]);
   const stageHistoryError = networkErrors[requestKey];

   return (
      <>
         {stageHistoryError?.error ? (
            <div>
               <YpErrorTooltip error={stageHistoryError.error} request={stageHistoryError.request} />
            </div>
         ) : null}
      </>
   );
});

StageHistorySpecError.displayName = 'StageHistorySpecError';
