import React from 'react';

import { UserName, UserOrGroupType } from '@yandex-infracloud-ui/libs';

import type { HistoryEvent } from '../../../../../../models/ui';
import { handleStopPropagation } from '../../../../../../utils';

import classes from './StageHistoryUserLink.module.css';

interface Props {
   historyEvent: HistoryEvent;
}

export const StageHistoryUserLink: React.FC<Props> = React.memo(({ historyEvent }) => (
   // eslint-disable-next-line jsx-a11y/no-static-element-interactions
   <div onClick={handleStopPropagation} className={classes.user}>
      <UserName
         value={{
            id: historyEvent.user ?? '',
            type: UserOrGroupType.People,
         }}
         className={classes.linkColor}
      />
   </div>
));
StageHistoryUserLink.displayName = 'StageHistoryUserLink';
