import { useCallback } from 'react';

import { useDispatch } from 'react-redux';

import {
   getHistoryEventStageRevision,
   getHistoryEventTime,
   HistoryEvent,
   HistorySpecRequestKeys,
} from '../../../../../models/ui';
import { EObjectType } from '../../../../../proto-typings';
import { fetchHistory, useStage } from '../../../../../redux';

export function useFetchHistoryEvent(stageId: string) {
   const { rawStage } = useStage(stageId);

   const { id = '', uuid = '' } = rawStage?.meta ?? {};

   const dispatch = useDispatch();

   const fetchHistoryEvent = useCallback(
      (event: HistoryEvent) => {
         const { seconds, nanos } = getHistoryEventTime(event);

         const thunk = fetchHistory.withRequestKey(
            HistorySpecRequestKeys.getOne({ id, revisionId: String(getHistoryEventStageRevision(event)) }),
         )({
            type: EObjectType.OT_STAGE,
            id,
            uuid,
            limit: 1,
            paths: ['/spec'],
            // descendingOrder: false,
            interval: {
               begin: { seconds, nanos },
               // временное решение, подробнее https://st.yandex-team.ru/DEPLOY-4331
               end: { seconds, nanos: nanos + 10000 },
            },
         });

         dispatch(thunk);
      },
      [dispatch, id, uuid],
   );

   return {
      fetchHistoryEvent,
   };
}
