import { useMemo } from 'react';
import { getHistoryEventStageRevision } from '../../../../../models/ui';

import { useHistoryList } from './useHistoryList';

export function useHistoryEvent(stageId: string, revisionId: number) {
   const { historyList } = useHistoryList(stageId);

   const historyEvent = useMemo(
      () => historyList.find(event => getHistoryEventStageRevision(event) === revisionId) ?? null,
      [historyList, revisionId],
   );

   return { historyEvent };
}
