import { useMemo } from 'react';

import { useStage } from '../../../../../redux';
import { toYaml } from '../../../../../utils';
import { useHistoryEvent } from './useHistoryEvent';

export function useHistoryEventText(stageId: string, revisionId: number) {
   const { historyEvent } = useHistoryEvent(stageId, revisionId);
   const { rawStage } = useStage(stageId);

   const historyEventText = useMemo(() => {
      const { spec = {}, meta = {} } = historyEvent?.result ?? {};
      const object = {
         spec,
         meta: {
            ...(rawStage?.meta ?? {}),
            ...meta,
         },
      };

      return toYaml(object);
   }, [historyEvent?.result, rawStage?.meta]);

   return { historyEventText };
}
