// переходы между страницами истории

import { useCallback } from 'react';
import { useHistory } from 'react-router';
import { urlBuilder } from '../../../../../models';

const getSorted = (r1: number, r2: number) => [r1, r2].sort((a, b) => a - b) as [number, number];

export function useHistoryGoto(stageId: string) {
   const history = useHistory();

   const goToHistoryList = useCallback(() => {
      history.push(urlBuilder.stageHistory(stageId));
   }, [history, stageId]);

   const gotoHistoryEvent = useCallback(
      (revisionId: number) => {
         history.push(urlBuilder.stageHistoryRevision(stageId, revisionId));
      },
      [history, stageId],
   );

   const gotoHistoryCompare = useCallback(
      (revisionId: number, revisionComparedId: number, sort = false) => {
         const revisions = sort
            ? getSorted(revisionId, revisionComparedId)
            : ([revisionId, revisionComparedId] as const);
         history.push(urlBuilder.stageHistoryCompare(stageId, ...revisions));
      },
      [history, stageId],
   );

   const gotoHistoryApply = useCallback(
      (revisionId: number, asIs = false) => {
         history.push(urlBuilder.stageHistoryApply(stageId, revisionId, asIs));
      },
      [history, stageId],
   );

   return {
      goToHistoryList,
      gotoHistoryEvent,
      gotoHistoryCompare,
      gotoHistoryApply,
   };
}
