import { useCallback } from 'react';
import { useSelector } from 'react-redux';

import { getListWithUniqRevisions } from '../../../../../models/ui';
import { EObjectType } from '../../../../../proto-typings';
import { RootState, selectHistory } from '../../../../../redux';

export function useHistoryList(stageId: string) {
   const historySelector = useCallback((state: RootState) => selectHistory(state, EObjectType.OT_STAGE, stageId), [
      stageId,
   ]);
   const historyList = useSelector(historySelector);
   const uniqueHistoryList = getListWithUniqRevisions(historyList);

   return { historyList: uniqueHistoryList };
}
