import React, { useEffect } from 'react';

import { SwitchRoutes, useTitle } from '@yandex-infracloud-ui/libs';
import { Spin } from '@yandex-cloud/uikit';
import { RouteComponentProps } from 'react-router';

import { useStage } from '../../../../redux';
import { HistoryDescriptionsContext, HistoryListLoadedContext } from './context';
import { useFetchHistory, useHistoryEventDescriptions, useHistoryList } from './hooks';
import { ROUTES } from './_routes';

import classes from './index.module.css';

export const StageHistoryPage: React.FC<RouteComponentProps<{ stageId: string }>> = React.memo(({ match }) => {
   const { stageId } = match.params;
   const { rawStage, stage } = useStage(stageId, false, true);

   useTitle(`History / ${stageId}`);

   const { isLoaded, fetchHistoryParts } = useFetchHistory(stageId);
   const { historyList } = useHistoryList(stageId);

   const { historyDescriptions } = useHistoryEventDescriptions(stageId);

   const stageRevision = stage?.revision;
   useEffect(() => {
      if (stageRevision) {
         // первоначальная загрузка для всех страниц
         // перезагрузка истории, если появилась новая ревизия
         // TODO: в идеале можно просто запрашивать кусок истории для новой ревизии, но пока yp так не умеет
         fetchHistoryParts({ init: true, size: 100 });
      }
   }, [fetchHistoryParts, stageRevision]);

   if (!rawStage) {
      return null;
   }

   if (historyList.length === 0 && !isLoaded) {
      return (
         <div className={classes.container}>
            <Spin size={'xl'} />
         </div>
      );
   }

   return (
      <HistoryListLoadedContext.Provider value={isLoaded}>
         <HistoryDescriptionsContext.Provider value={historyDescriptions}>
            <SwitchRoutes>{ROUTES}</SwitchRoutes>
         </HistoryDescriptionsContext.Provider>
      </HistoryListLoadedContext.Provider>
   );
});

StageHistoryPage.displayName = 'StageHistoryPage';
