import React from 'react';

import { RouteComponentProps } from 'react-router';

import { useStage } from '../../../../../redux';
import { StageHistoryList } from '../components';
import { useHistoryList } from '../hooks';

export const StageHistoryListPage: React.FC<RouteComponentProps<{ stageId: string }>> = React.memo(routeProps => {
   const { match } = routeProps;
   const { stageId } = match.params;

   const { rawStage } = useStage(stageId);

   const { historyList } = useHistoryList(stageId);

   if (!rawStage) {
      return null;
   }

   return <StageHistoryList stage={rawStage} historyList={historyList} />;
});
