import { Json, useTitle } from '@yandex-infracloud-ui/libs';
import React from 'react';
import { RouteComponentProps } from 'react-router';

import { useStage } from '../../../../redux';

import classes from './StageJsonPage.module.css';

export const StageJsonPage: React.FC<RouteComponentProps<{ stageId: string }>> = React.memo(({ match }) => {
   const { stageId } = match.params;
   const { rawStage } = useStage(stageId, true);

   useTitle(`JSON / ${stageId}`);

   return rawStage ? (
      <div className={classes.wrapper}>
         <Json obj={rawStage} hidePre />
      </div>
   ) : null;
});

StageJsonPage.displayName = 'StageJsonPage';
