import { fromQuery, sortHandler, useTitle } from '@yandex-infracloud-ui/libs';
import React, { useEffect, useMemo, useState } from 'react';
import { RouteComponentProps, useHistory } from 'react-router';

import { DeployLogPage } from '../../../../components/deploy-log-page';
import { urlBuilder } from '../../../../models';
import { ApiServiceEndpointName } from '../../../../models/api';
import StageLogs from '../../../../old-code/containers/StageLogs/StageLogs';
import { useFormStage } from '../../../../redux';
import { Config, useConfig } from '../../../../services';

import classes from './StageLogsPage.module.css';

export const StageLogsPage: React.FC<RouteComponentProps<{ stageId: string }>> = React.memo(({ location, match }) => {
   const { stageId } = match.params;
   const { rawStage } = useFormStage(`${stageId}-logs`, stageId);

   const deployUnitIds = useMemo(
      () =>
         Object.keys(rawStage?.spec?.deploy_units ?? {}).sort((a, b) => sortHandler(a.toLowerCase(), b.toLowerCase())),
      [rawStage],
   );

   const config = useConfig();
   const apiEndpoint = config?.getApiEndpointForService(ApiServiceEndpointName.Deploy);
   const showNewLogs = config?.isShowNewLogs();

   const [queryString, setQueryString] = useState(location.search);

   const history = useHistory();

   useEffect(() => {
      if (showNewLogs) {
         Config.ym({ method: 'reachGoal', goal: 'new-logs-visits' });
      } else {
         Config.ym({ method: 'reachGoal', goal: 'old-logs-visits' });
      }
   }, [showNewLogs]);

   useEffect(() => {
      // считаем каждый раз, когда изменяются параметры урла (фильтры)
      if (showNewLogs) {
         // скипаем редиректы с пустыми фильтрами
         if (location.search) {
            const { deployUnitId } = fromQuery(location.search);

            if (deployUnitId) {
               Config.ym({ method: 'reachGoal', goal: 'new-logs' });
            }
         }
      } else {
         Config.ym({ method: 'reachGoal', goal: 'old-logs' });
      }
   }, [location.search, showNewLogs]);

   useEffect(() => {
      if (showNewLogs) {
         history.push(urlBuilder.stageLogs(stageId, fromQuery(queryString)));
      }
   }, [history, queryString, stageId, showNewLogs]);

   useTitle(`Logs / ${stageId}`);

   return rawStage ? (
      <>
         {!showNewLogs ? (
            <StageLogs stage={rawStage} />
         ) : (
            <>
               {rawStage?.meta?.project_id && apiEndpoint ? (
                  <div className={classes.wrapper}>
                     {/* <pre>{queryString}</pre> */}

                     <DeployLogPage
                        apiEndpoint={`${apiEndpoint}/api/logs/`}
                        deployUnitIds={deployUnitIds}
                        onQueryStringUpdate={setQueryString}
                        projectId={rawStage.meta.project_id}
                        queryString={queryString}
                        stageId={stageId}
                        filtersClassName={classes.filters}
                     />
                  </div>
               ) : null}
            </>
         )}
      </>
   ) : null;
});

StageLogsPage.displayName = 'StageLogsPage';
