import { ExtendedFieldConfig, SwitcherField2, useExtendedField, WarningPlate } from '@yandex-infracloud-ui/libs';
import React from 'react';

import classes from './AutocommitField.module.css';

export const AutocommitField = React.memo((props: ExtendedFieldConfig<any, boolean | null>) => {
   const { field } = useExtendedField(props);
   const { value } = field;

   return (
      <>
         <SwitcherField2 {...props} required={false} />

         {value && (
            <WarningPlate theme={'danger'} className={classes.warning}>
               Autocommit is a dangerous option. Do not use it for production services.
            </WarningPlate>
         )}
      </>
   );
});

AutocommitField.displayName = 'AutocommitField';
