import { FormContext, Loader } from '@yandex-infracloud-ui/libs';
import React, { useCallback, useContext } from 'react';

import { SelectStagePart, StagePart, StagePartType } from '../../../../../../../components';
import { ReleaseRuleFormContext } from '../../../models';

interface Props {
   deployUnit: string;
   disabled?: boolean;
   id: string;

   onSelect(v: StagePart | null): void;
}

export const TargetSelect: React.FC<Props> = React.memo(({ id, deployUnit, disabled = false, onSelect }) => {
   const { stage } = useContext(FormContext) as ReleaseRuleFormContext;

   const handleSelect = useCallback(
      (v: StagePart | null) => {
         onSelect(v);
      },
      [onSelect],
   );

   if (!stage) {
      return <Loader />;
   }

   const value: StagePart | null = id
      ? {
           stage: stage.id,
           type: StagePartType.Box,
           deployUnit,
           box: id,
        }
      : null;

   return (
      <SelectStagePart
         disabled={disabled}
         type={StagePartType.Box}
         placeholder={'Select stage box'}
         value={value}
         onChange={handleSelect}
         stage={stage}
      />
   );
});

TargetSelect.displayName = 'TargetSelect';
