import { ExtendedFieldConfig, unique } from '@yandex-infracloud-ui/libs';
import React, { useCallback, useMemo, useState } from 'react';

import { YCSelectField } from '../../../../../../../../components/forms';
import { ReleaseType } from '../../../../../../../../models/ui';

const defaultReleaseTypeValues = [ReleaseType.Stable, ReleaseType.Prestable, ReleaseType.Testing, ReleaseType.Unstable];

export const ReleaseTypesField = React.memo((props: ExtendedFieldConfig<any, string[], any>) => {
   const value: (ReleaseType | string)[] = useMemo(() => props.value, [props.value]);

   const [itemValues, setItemValues] = useState(
      unique(value ? [...defaultReleaseTypeValues, ...value] : defaultReleaseTypeValues),
   );

   const items = useMemo(
      () =>
         itemValues.sort().map(v => ({
            value: v,
            title: v,
         })),
      [itemValues],
   );

   const handleAddItem = useCallback((v: string) => {
      setItemValues(values => (v ? unique([...values, v.toLowerCase().trim()]) : values));
   }, []);

   return (
      <YCSelectField
         {...props}
         controlProps={{
            items,
            addItem: handleAddItem as any,
            showSelectAll: true,
            type: 'multiple',
            placeholder: props.placeholder,
         }}
      />
   );
});

ReleaseTypesField.displayName = 'ReleaseTypesField';
