import { Table, TableColumnConfig } from '@yandex-cloud/uikit';
import React from 'react';

import { DockerPatch } from '../../../../../../../models/ui';

interface Props {
   patches: DockerPatch[] | undefined;
}

interface PatchRow {
   id: string;
   deployUnitId: string;
   boxId: string;
}

const columns: TableColumnConfig<PatchRow>[] = [
   { id: 'id', name: 'Patch name' },
   { id: 'deployUnitId', name: 'Deploy unit ID' },
   { id: 'boxId', name: 'Box ID' },
];

export const ReleaseRuleReadonlyPageDockerPatches: React.FC<Props> = React.memo(({ patches }) => (
   <Table
      columns={columns}
      data={(patches ?? []).map(patch => ({
         id: patch.id,
         deployUnitId: patch.deployUnitId,
         boxId: patch.boxId,
      }))}
      emptyMessage={'No patches.'}
      verticalAlign={'top'}
   />
));

ReleaseRuleReadonlyPageDockerPatches.displayName = 'ReleaseRuleReadonlyPageDockerPatches';
