import { Table, TableColumnConfig } from '@yandex-cloud/uikit';
import React from 'react';

import { ResourceType, SandboxPatch } from '../../../../../../../models/ui';

interface Props {
   patches: SandboxPatch[] | undefined;
}

interface PatchRow {
   id: string;
   type: ResourceType;
   resourceType: string;
   deployUnitId?: string;
   deployGroupMark?: string;
   ref: string;
}

const columns: TableColumnConfig<PatchRow>[] = [
   { id: 'id', name: 'Patch name' },
   { id: 'type', name: 'Type' },
   { id: 'resourceType', name: 'Resource type' },
   { id: 'deployUnitId', name: 'Deploy unit ID' },
   { id: 'deployGroupMark', name: 'Deploy group mark' },
   { id: 'ref', name: 'Target' },
];

export const ReleaseRuleReadonlyPageSandboxPatches: React.FC<Props> = React.memo(({ patches }) => (
   <Table
      columns={columns}
      data={(patches ?? []).map(patch => ({
         id: patch.id,
         type: patch.type,
         resourceType: patch.resourceType,
         deployUnitId: patch.type !== ResourceType.DynamicResource ? patch.deployUnitId : undefined,
         deployGroupMark: patch.type === ResourceType.DynamicResource ? patch.deployGroupMark : undefined,
         ref: patch.ref,
      }))}
      emptyMessage={'No patches.'}
      verticalAlign={'top'}
   />
));

ReleaseRuleReadonlyPageSandboxPatches.displayName = 'ReleaseRuleReadonlyPageSandboxPatches';
