import { FormContext, Loader } from '@yandex-infracloud-ui/libs';
import React, { useCallback, useContext } from 'react';

import { SelectStagePart, StagePart, StagePartType } from '../../../../../../../components';
import { ResourceType } from '../../../../../../../models/ui';

import { ReleaseRuleFormContext } from '../../../models';

interface Props {
   deployGroupMark?: string;
   deployUnit: string;
   disabled?: boolean;
   id: string;
   type: ResourceType;

   onSelect(v: StagePart | null): void;
}

export const TargetSelect: React.FC<Props> = React.memo(
   ({ type, id, deployUnit, deployGroupMark = '', disabled = false, onSelect }) => {
      const { stage } = useContext(FormContext) as ReleaseRuleFormContext;

      const handleSelect = useCallback(
         (v: StagePart | null) => {
            onSelect(v);
         },
         [onSelect],
      );

      if (!stage) {
         return <Loader />;
      }

      const value: StagePart | null = id
         ? {
              stage: stage.id,
              type: StagePartType.Resource,
              deployUnit,
              resource: type === ResourceType.DynamicResource ? { type, id, deployGroupMark } : { type, id },
           }
         : null;

      return (
         <SelectStagePart
            disabled={disabled}
            type={StagePartType.Resource}
            placeholder={'Select stage resource'}
            value={value}
            onChange={handleSelect}
            stage={stage}
         />
      );
   },
);

TargetSelect.displayName = 'TargetSelect';
