import { useMemo } from 'react';

import { DockerMappingTarget, Stage } from '../../../../models/ui';
import { useStage } from '../../../../redux';

export interface ReleaseRuleFormContext {
   dockerTargets: DockerMappingTarget[];
   isNew: boolean;

   stage: Stage | null;
}

export function useReleaseRuleFormContext(stageId: string, isNew: boolean): ReleaseRuleFormContext {
   const { stage } = useStage(stageId);

   return useMemo(
      () => ({
         dockerTargets: stage ? stage.dockerTargets : [],
         isNew,
         stage,
      }),
      [isNew, stage],
   );
}
