import { Meta } from '@storybook/react';
import React from 'react';
import { apiServicesContextDecorator, routerDecorator, RouteRenderer } from '../../../../stories';

import { NewReleaseRulePage } from './new';

export const Regular = () => (
   <RouteRenderer
      component={NewReleaseRulePage}
      path={'/stage/:stageId/release_rules/new'}
      url={'/stage/test-release-integration-stage/release_rules/new'}
   />
);

export const HugeResourceNames = () => (
   <RouteRenderer
      component={NewReleaseRulePage}
      path={'/stage/:stageId/release_rules/new'}
      url={'/stage/weather-apphost-services-test/release_rules/new'}
   />
);

export default {
   decorators: [routerDecorator, apiServicesContextDecorator],
   title: 'pages/stages/_stageId/release_rules/new',
} as Meta;
