import React, { useMemo } from 'react';

import { classNames } from '@yandex-infracloud-ui/libs';

import { PodBox } from '../../../../../../models/ui';
import { CopyWrapper } from '../../../../../../components/lib';

import classes from './BoxIp.module.css';

interface Props {
   box: PodBox;
   fqdn: string;
   isSox: boolean;
}

enum USER {
   Root = 'root',
   Nobody = 'nobody',
}

export const BoxIp: React.FC<Props> = React.memo(({ box, fqdn, isSox }) => {
   const { ip6Address, id } = box;
   const getIp6Ssh = (user: string) => `ssh ${user}@${ip6Address}`;
   const getFqdnSsh = (user: string) => `ssh ${user}@${id}.${fqdn}`;

   const users = useMemo(() => [...(isSox ? [USER.Nobody] : []), USER.Root], [isSox]);

   return (
      <div className={classes.users}>
         {users.map((user, i) => {
            const fqdnSsh = getFqdnSsh(user);
            const ipv6Ssh = getIp6Ssh(user);

            return (
               <div className={classNames(classes.ssh, { [classes.secondaryUser]: i > 0 })} key={user}>
                  <div className={classes.user}>{user}@</div>
                  <div key={`fqdn-${user}`}>
                     <CopyWrapper text={fqdnSsh}>
                        <a href={`ssh://${user}@${id}.${fqdn}`} rel={'noopener noreferrer'} title={fqdnSsh}>
                           SSH
                        </a>
                     </CopyWrapper>
                  </div>
                  <div key={`ipv6-${user}`}>
                     <CopyWrapper text={ipv6Ssh}>
                        <span title={ipv6Ssh}>IPv6</span>
                     </CopyWrapper>
                  </div>
               </div>
            );
         })}
      </div>
   );
});

BoxIp.displayName = 'BoxIp';
