import React from 'react';

import { StatusState } from '../../../../../../components/lib';
import { PodBox, PodObjectName } from '../../../../../../models/ui';
import { EBoxState } from '../../../../../../proto-typings';
import { PodObjectStatus } from '../PodObjectStatus/PodObjectStatus';

const statusMap: Record<EBoxState, StatusState> = {
   [EBoxState.EBoxState_CREATING_ROOTFS_VOLUME]: StatusState.Progress,
   [EBoxState.EBoxState_CREATING_ROOT_CONTAINER]: StatusState.Progress,
   [EBoxState.EBoxState_INIT_PROCESSES]: StatusState.Progress,
   [EBoxState.EBoxState_INVALID]: StatusState.Error,
   [EBoxState.EBoxState_LINKING_VOLUMES]: StatusState.Progress,
   [EBoxState.EBoxState_READY]: StatusState.Ok,
   [EBoxState.EBoxState_REMOVED]: StatusState.Inactive,
   [EBoxState.EBoxState_REMOVING]: StatusState.Progress,
   [EBoxState.EBoxState_UNKNOWN]: StatusState.Unknown,
   [EBoxState.EBoxState_WAITING_FOR_ROOTFS_LAYERS]: StatusState.Progress,
   [EBoxState.EBoxState_WAITING_FOR_STATIC_RESOURCES]: StatusState.Progress,
   [EBoxState.EBoxState_WAITING_FOR_VOLUMES]: StatusState.Progress,
};

interface Props {
   box: PodBox;
   inline?: boolean;
}

export const BoxStatus: React.FC<Props> = React.memo(({ box, inline }) => (
   <PodObjectStatus
      type={PodObjectName.Box}
      podObject={box}
      state={box.state}
      statusMap={statusMap}
      inline={inline ?? false}
   />
));

BoxStatus.displayName = 'BoxStatus';
