import React from 'react';

import { useStage } from '../../../../../../redux';
import { useArrayMemo } from '../../../../../../utils';
import { DeployUnitTab } from '../DeployUnitTab/DeployUnitTab';
import { StatusTab } from '../StatusTab/StatusTab';

interface Props {
   stageId: string;
   onSelect(duId: string): void;
   selectedDuId: string;
}

export const DeployUnitList: React.FC<Props> = React.memo(({ stageId, onSelect, selectedDuId }) => {
   const { stageStatusLabel } = useStage(stageId);

   const { deployUnitLabels } = stageStatusLabel ?? {};
   const keyList = useArrayMemo(Array.from(deployUnitLabels?.keys() ?? []).sort());

   if (!stageStatusLabel) {
      return null;
   }

   if (!deployUnitLabels) {
      return null;
   }

   if (deployUnitLabels.size === 0) {
      return null;
   }

   return (
      <div>
         {keyList.map(duId => (
            <StatusTab
               onSelect={() => onSelect(duId)}
               active={selectedDuId === duId}
               key={`deploy-unit-${duId}`}
               dataTest={'status--deploy-unit'}
               ariaLabel={'Deploy Unit status'}
            >
               <DeployUnitTab stageId={stageId} duId={duId} />
            </StatusTab>
         ))}
      </div>
   );
});

DeployUnitList.displayName = 'DeployUnitList';
