import { Popover } from '@yandex-cloud/uikit';
import { Collapse } from '@yandex-data-ui/common';
import { Json } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { Status, StatusLabel, StatusState } from '../../../../../../components/lib';
import { DeployUnitState } from '../../../../../../models/ui/stage/DeployUnit/DeployUnitStatusConverter';
import { DeployUnitStatusView } from '../../../../../../models/ui/status';

interface Props {
   deployUnitStatusView: DeployUnitStatusView;
}

const statusesMap: Record<DeployUnitState, StatusState> = {
   [DeployUnitState.Ready]: StatusState.Ok,
   [DeployUnitState.InProgress]: StatusState.Progress,
   [DeployUnitState.Failed]: StatusState.Error,
   [DeployUnitState.Unknown]: StatusState.Unknown,
};

export const DeployUnitStatus: React.FC<Props> = React.memo(({ deployUnitStatusView }) => {
   const { mergeDeployUnitLabel, deployUnitLabel } = deployUnitStatusView;
   const { text, state, message, calculate } = mergeDeployUnitLabel;
   const statusState = statusesMap[state];
   const status = <Status state={statusState}>{text}</Status>;

   const showLabel = Boolean(message) || calculate;

   if (showLabel) {
      return (
         <div style={{ marginLeft: '-8px' }}>
            <Popover
               content={
                  <div>
                     {message}
                     {calculate && (
                        <div>
                           <strong>Raw status</strong>
                           <br />
                           <Status state={statusesMap[deployUnitLabel.state]}>{deployUnitLabel.text}</Status>
                           <Collapse title={<span>JSON</span>}>
                              <Json obj={deployUnitStatusView.deployUnitLabel} />
                           </Collapse>
                        </div>
                     )}
                  </div>
               }
            >
               <StatusLabel state={statusState} text={text}>
                  {status}
               </StatusLabel>
            </Popover>
         </div>
      );
   }

   return status;
});

DeployUnitStatus.displayName = 'DeployUnitStatus';
