import React from 'react';

import { classNames, Loader } from '@yandex-infracloud-ui/libs';

import { OrderList } from '../../../../../../components/lib';
import { DeployUnitState } from '../../../../../../models/ui/stage/DeployUnit/DeployUnitStatusConverter';
import { useDeployUnit } from '../../../../../../redux';
import { DeployUnitStatus } from '../DeployUnitStatus/DeployUnitStatus';
import { useDeployUnitStatusView } from '../../hooks';

import classes from './DeployUnitTab.module.css';

interface Props {
   stageId: string;
   duId: string;
}

export const DeployUnitTab: React.FC<Props> = React.memo(({ stageId, duId }) => {
   const { deployUnit, deployUnitStatus } = useDeployUnit(stageId, duId);
   const { deployUnitStatusViewList } = useDeployUnitStatusView({ deployUnitSelectData: [{ stageId, duId }] });
   const [deployUnitStatusView = null] = deployUnitStatusViewList;

   const duName = (
      <div className={classes.name} data-test={'deploy-unit--name'} title={duId}>
         {duId}
      </div>
   );

   if (!deployUnitStatus) {
      return (
         <div>
            {duName}
            <div className={classes.creation}>
               Waiting creation
               <Loader inline={true} />
            </div>
         </div>
      );
   }

   if (!deployUnit) {
      return (
         <div>
            {duName}
            <div className={classes.creation}>No data</div>
         </div>
      );
   }

   if (!deployUnitStatusView) {
      return null;
   }

   const {
      targetRevision,
      locations,
      mergeDeployUnitLabel,
      spec: { revision },
      waitingForApprove,
   } = deployUnitStatusView;
   const { state } = mergeDeployUnitLabel;
   const isInProgress = state === DeployUnitState.InProgress;

   const noPods = locations.size === 0;

   return (
      <div>
         {duName}
         <div className={classes.info}>
            <div data-test={'deploy-unit--badge'}>
               <DeployUnitStatus deployUnitStatusView={deployUnitStatusView} />
            </div>

            <div className={classNames(classes.revision)}>
               <div>
                  {isInProgress && targetRevision === revision && 'Target '}
                  Rev &nbsp;
                  <span data-test={'deploy-unit--revision'}>{targetRevision ?? 'N/A'}</span>
               </div>
               {targetRevision !== revision && <OrderList items={[<span> </span>, revision]} />}
            </div>
         </div>

         {waitingForApprove && <div className={classes.approve}>Waiting for approve</div>}

         {noPods && <div className={classes.noPods}>no pods</div>}
      </div>
   );
});

DeployUnitTab.displayName = 'DeployUnitTab';
