import React from 'react';

import { StatusState } from '../../../../../../components/lib';
import { PodLayer, PodObjectName } from '../../../../../../models/ui';
import { ELayerState } from '../../../../../../proto-typings';
import { PodObjectStatus } from '../PodObjectStatus/PodObjectStatus';

const statusMap: Record<ELayerState, StatusState> = {
   [ELayerState.ELayerState_DOWNLOADING]: StatusState.Progress,
   [ELayerState.ELayerState_IMPORTING]: StatusState.Progress,
   [ELayerState.ELayerState_INVALID]: StatusState.Error,
   [ELayerState.ELayerState_IN_QUEUE]: StatusState.Progress,
   [ELayerState.ELayerState_READY]: StatusState.Ok,
   [ELayerState.ELayerState_REMOVED]: StatusState.Inactive,
   [ELayerState.ELayerState_REMOVING]: StatusState.Progress,
   [ELayerState.ELayerState_UNKNOWN]: StatusState.Unknown,
   [ELayerState.ELayerState_VERIFICATION_IN_QUEUE]: StatusState.Progress,
   [ELayerState.ELayerState_VERIFYING]: StatusState.Progress,
   [ELayerState.ELayerState_WAITING_FOR_RESOURCE_GANG_META_CONTAINER]: StatusState.Progress,
};

interface Props {
   layer: PodLayer;
   inline?: boolean;
}

export const LayerStatus: React.FC<Props> = React.memo(({ layer, inline }) => (
   <PodObjectStatus
      type={PodObjectName.Layer}
      podObject={layer}
      state={layer.state}
      statusMap={statusMap}
      inline={inline ?? false}
   />
));

LayerStatus.displayName = 'LayerStatus';
