import React from 'react';

import { Status, StatusState } from '../../../../../../components/lib';
import { PodCurrentState } from '../../../../../../models/ui';
import { statusMap } from '../../model';

interface Props {
   state: PodCurrentState | null;
}

export const PodAgentStatus: React.FC<Props> = React.memo(({ state }) => (
   <Status state={state ? statusMap[state] : StatusState.Unknown}>
      {state ? String(state).replaceAll('_', ' ').toLocaleLowerCase() : 'unknown'}
   </Status>
));

PodAgentStatus.displayName = 'PodAgentStatus';
