import React from 'react';
import { Pod, PodObject, PodObjectName, PodObjectTitle } from '../../../../../../models/ui/runtimeDeploy';
import { PodObjectDataConfig } from '../../model';
import { RuntimeObjectRevision } from '../RuntimeObjectRevision/RuntimeObjectRevision';
import { RuntimeWarning } from '../RuntimeWarning/RuntimeWarning';

import classes from './PodError.module.css';

interface ItemsProps<T> {
   type: PodObjectName;
   items: Map<string, T> | ReadonlyMap<string, T>;
}

const WarningItems = <T extends PodObject>({ type, items }: ItemsProps<T>) => {
   const title = PodObjectTitle[type];
   const getData = PodObjectDataConfig[type];
   return (
      <>
         {Array.from(items.entries()).map(([id, podObject]) => {
            const { inlineStatus } = getData(podObject as any);
            return (
               <RuntimeWarning key={`${title}-${id}`} title={title} id={id} level={podObject.warning}>
                  <div className={classes.objectData}>
                     {inlineStatus}
                     <RuntimeObjectRevision
                        revision={podObject.revision}
                        targetRevision={podObject.targetRevision}
                        progress={podObject.statusStateInfo.inProgress.active}
                        full={true}
                     />
                  </div>
               </RuntimeWarning>
            );
         })}
      </>
   );
};
interface Props {
   pod: Pod;
}

export const PodError: React.FC<Props> = React.memo(({ pod }) => {
   const { boxes, workloads, layers, volumes, staticResources } = pod;

   return (
      <div>
         <RuntimeWarning level={pod.warning} />
         <WarningItems type={PodObjectName.Box} items={boxes} />
         <WarningItems type={PodObjectName.Workload} items={workloads} />
         <WarningItems type={PodObjectName.Layer} items={layers} />
         <WarningItems type={PodObjectName.Volume} items={volumes} />
         <WarningItems type={PodObjectName.StaticResource} items={staticResources} />
      </div>
   );
});

PodError.displayName = 'PodError';
