export function makeLogsQuery(params: Record<string, string | undefined>): string | undefined {
   return params
      ? Object.entries(params)
           .map(([key, value]) => (value ? `${key}=${value};` : ''))
           .join('')
      : undefined;
}
