import React from 'react';
import { YpError } from '../../../../../../components';
import { ReplicaSetWarning } from '../../../../../../models/ui/runtimeDeploy';

import classes from './ReplicaSetError.module.css';

interface Props {
   warning: ReplicaSetWarning;
}

export const ReplicaSetError: React.FC<Props> = React.memo(({ warning }) => {
   const { replicaSet, count } = warning;

   if (count === 0) {
      return null;
   }
   return (
      <div className={classes.error}>
         <YpError level={replicaSet} />
      </div>
   );
});

ReplicaSetError.displayName = 'ReplicaSetError';

/*
вложенность, к которой мы стремимся

pod
  boxes
    workloads
    layers
    static resources
    dynamic resources
  volumes
*/
